#version 100
// Mysterious definitely-self-made shader code. Do not distribute for other purposes.
precision mediump float;

varying vec2 uv;
uniform sampler2D screenTexture;

uniform float progress; // %0% 0..1

float rand(float n){return fract(sin(n)*43758.5453123);}

float noise(float p){
    float fl=floor(p);
    float fc=fract(p);
    return mix(rand(fl),rand(fl+1.),fc);
}

//CC_Texture0
void main()
{
    vec4 col=texture2D(screenTexture,uv);
    
    //float time = CC_Time[2];
    
    const float distanceBetween=.1;
    const float distanceBetweenhalf=distanceBetween*.5;
    const float waveFreq=50.;
    const float waveFreq2=70.;
    const float waveIntensityMax=.05;
    
    float y=uv.y;
    
    float ySin1=sin(y*waveFreq)*waveIntensityMax;
    float ySin2=sin(y*waveFreq2)*waveIntensityMax;
    
    float ySin=(ySin1*.5)+(ySin2*.5);
    
    float targetX=progress+ySin+(((y*2.)-1.));
    
    //
    float dist=distance(min(targetX,uv.x),targetX);
    
    vec4 sample;
    sample=texture2D(screenTexture,uv);
    float rawSampleA=sample.a;
    
    // If the distance is close to the line, or passed the point of it, start blending against the line
    if(dist<.05&&rawSampleA>.001){
        float withinDist=distance(dist,.025)/.025;
        
        float barA=1.-(pow(withinDist,.65));
        vec4 barResult=vec4(1.,1.,1.,1.)*barA;
        if(dist<.025){
            sample*=(1.-barA);
            sample+=barResult;
        }
        else{
            sample=barResult;
        }
    }
    // If it's ahead of the line, show nothing
    else{
        sample*=0.;
    }
    
    // sample*=col;
    gl_FragColor=sample;
}