#version 100
// https://www.shadertoy.com/view/MlBSzR
precision highp float;

varying lowp vec2 uv;
uniform sampler2D screenTexture;
uniform float time;

uniform float strength;// %0.5%
uniform float rate;// %0.5%

float my_trunc(float x){
    return x<0.?-floor(-x):floor(x);
}

float random(float seed){
    return fract(543.2543*sin(dot(vec2(seed,seed),vec2(3525.46,-54.3415))));
}

void main(){
    float x=uv.x;
    float y=uv.y;
    
    if(random(my_trunc(time))<rate && strength>0.){
        // get snapped position
        float psize=.04*strength;
        float psq=1./psize;
        
        float px=floor(x*psq+.5)*psize;
        float py=floor(y*psq+.5)*psize;
        
        vec4 colSnap=texture2D(screenTexture,vec2(px,py));
        
        float lum=pow((colSnap.r+colSnap.g+colSnap.b)/3.,strength);// remove the minus one if you want to invert luma
        
        // do move with lum as multiplying factor
        float qsize=psize*lum;
        
        float qsq=1./qsize;
        
        float qx=floor(x*qsq+.5)*qsize;
        float qy=floor(y*qsq+.5)*qsize;
        
        float rx=(px-qx)*lum+x;
        float ry=(py-qy)*lum+y;
        
        vec4 colMove=texture2D(screenTexture,vec2(rx,ry));
        gl_FragColor=colMove;
    }
    else
        gl_FragColor=texture2D(screenTexture,uv);
}