#version 100
// Adapted from https://godotshaders.com/shader/chromatic-abberation/
precision mediump float;

varying lowp vec2 uv;
uniform sampler2D screenTexture;

uniform float sampleCount;// %3% int 1..64
uniform float power;// %0.01%

vec3 chromatic_slice(float t){
    vec3 res=vec3(1.-t,1.-abs(t-1.),t-1.);
    return max(res,0.);
}
#define PI				3.141592653589793
float easeSineInOut(float t) {
    return -0.5 * (cos(PI * t * 2.0) - 1.0);
}
void main(){
    vec3 sum=vec3(0.);
    vec3 c=vec3(0.);
    vec2 offset=(uv-vec2(.5))*vec2(1,-1);
    float b=length(offset);
    int sample_count=int(sampleCount);
    for(int i=0;i<64;++i){
        if(i>=sample_count)break;
        float t=2.*float(i)/float(sample_count-1);// range 0.0->2.0
        vec3 slice=vec3(1.-t,1.-abs(t-1.),t-1.);
        slice=max(slice,0.);
        sum+=slice;
        vec2 slice_offset=(t-1.)*power*offset*easeSineInOut(b);
        c+=slice*texture2D(screenTexture,uv+slice_offset).rgb;
    }
    gl_FragColor.rgb=c/sum;
}