#version 100
precision mediump float;

varying lowp vec2 uv;
uniform sampler2D screenTexture;
uniform float time;

uniform float sampleCount;// %3% int 1..64
uniform float power;// %0.01%
uniform float speed;// %5.0%
uniform float rate;// %0.5%

float my_trunc(float x){
    return x<0.?-floor(-x):floor(x);
}

float randomi(float seed){
    return fract(543.2543*sin(dot(vec2(seed,seed),vec2(3525.46,-54.3415))));
}

float random(float seed){
    return sin(fract(543.2543*sin(dot(vec2(seed,seed),vec2(3525.46,-54.3415))))*2307.9461);
}

void main(){
    if(randomi(my_trunc(time))<rate){
        vec3 sum=vec3(0.);
        vec3 c=vec3(0.);
        vec2 offset=(uv-vec2(.5))*vec2(random(time*speed),random(time*speed*2.));
        int sample_count=int(sampleCount);
        for(int i=0;i<64;++i){
            if(i>=sample_count)break;
            float t=2.*float(i)/float(sample_count-1);// range 0.0->2.0
            vec3 slice=vec3(1.-t,1.-abs(t-1.),t-1.);
            slice=max(slice,0.);
            sum+=slice;
            vec2 slice_offset=(t-1.)*power*offset;
            c+=slice*texture2D(screenTexture,uv+slice_offset).rgb;
        }
        gl_FragColor.rgb=c/sum;
    }
    else gl_FragColor=texture2D(screenTexture,uv);
}