#version 100
// Mysterious definitely-self-made shader code. Do not distribute for other purposes.
precision highp float;

varying vec2 uv;
uniform sampler2D screenTexture;
uniform float time;

uniform float params; // %0.0% 0..1

float rand(float n){return fract(sin(n)*43758.5453123);}

// float noise(float p){
    // 	float fl = floor(p);
    //     float fc = fract(p);
    // 	return mix(rand(fl), rand(fl + 1.0), fc);
// }

vec3 hueShift(vec3 Color,float Shift)
{
    vec3 P=vec3(.55735)*dot(vec3(.55735),Color);
    vec3 U=Color-P;
    vec3 V=cross(vec3(.55735),U);
    Color=U*cos(Shift*6.2832)+V*sin(Shift*6.2832)+P;
    return vec3(Color);
}

void main(void)
{
    // don't both unpacking these?
    float glitch_intensity=0.0;
    float aberration_intensity=params;
    float hue_progress=0.0;
    float desat_intensity=0.0;

    vec4 aberration_direction_norm = vec4(1.0, 0.0, 0.0, 0.0);
    
    vec2 samplePoint=uv;
    vec2 direction=vec2(0,0);
    {
        // glitch
        direction=glitch_intensity*vec2(.001,0);
        float modValueX=.00137+rand(time-mod(time,.053));
        float yPoint=(samplePoint.y-mod(samplePoint.y,modValueX));
        float adjustedPointX=mod(rand(yPoint),.0137);
        samplePoint.x+=glitch_intensity*(adjustedPointX*3.);
    }
    
    vec4 orig=texture2D(screenTexture,samplePoint+direction);
    
    {
        // aberration
        float aberrationAmount=.01*aberration_intensity;
        vec2 aberrated=aberration_direction_norm.xy*aberrationAmount;
        vec4 left=texture2D(screenTexture,samplePoint-aberrated);
        vec4 right=texture2D(screenTexture,samplePoint+aberrated);
        orig.r=left.r;
        orig.b=right.b;
    }
    
    {
        // hue
        orig.rgb=hueShift(orig.rgb,hue_progress);
    }
    
    {
        // desat
        float L=.3*orig.r+.6*orig.g+.1*orig.b;
        orig.r+=desat_intensity*(L-orig.r);
        orig.g+=desat_intensity*(L-orig.g);
        orig.b+=desat_intensity*(L-orig.b);
    }
    
    gl_FragColor=orig;
}
